


PRAGMA foreign_keys = ON; BEGIN TRANSACTION;




CREATE TABLE AcePolicyResult (
    decision INTEGER check(decision between 0 and 6) not null,
    hash TEXT not null,
    PRIMARY KEY(hash) ,


CHECK(1) );

CREATE TABLE AcePromptDecision (
    app_id INTEGER not null,
    decision INTEGER check(decision between 0 and 5) not null,
    session TEXT ,
    hash TEXT not null,
    PRIMARY KEY(app_id,hash) ,


CHECK(1) );

CREATE TABLE AceAttribute (
    attr_id INTEGER primary key autoincrement not null,
    name TEXT not null,
    type INTEGER check(type between 0 and 4) not null,

    unique(name,type) ,
CHECK(1) );

CREATE TABLE AceSubject (
    subject_id INTEGER primary key autoincrement not null,
    id_uri TEXT unique not null,
CHECK(1) );

CREATE TABLE AceDevCap (
    resource_id INTEGER primary key autoincrement not null,
    id_uri TEXT unique not null,
    general_setting INTEGER check(general_setting between -1 and 4) not null,
CHECK(1) );

CREATE TABLE AceWidgetDevCapSetting (
    app_id INTEGER not null not null,
    resource_id INTEGER references AceDevCap(resource_id) not null,
    access_value INTEGER check(access_value between -1 and 4) not null,

    unique(app_id,resource_id) ,
CHECK(1) );

CREATE TABLE AceRequestedDevCaps (
    app_id INTEGER not null not null,
    grant_smack INTEGER not null not null,
    dev_cap TEXT not null,

    unique(app_id,dev_cap) ,
CHECK(1) );

COMMIT;
BEGIN TRANSACTION; CREATE TABLE DB_VERSION_f5d7a4e4bd7a11f7225352298d2c631c (version INT); COMMIT;


