#!/bin/sh

_M="${0##*/}"

if [ $1 != "af" -a $1 != "card" ]; then
	echo "not support led ($1)"
	exit 0
else
	_device="$1"
fi

if [ $2 = "on" ]; then	
	_lstate=1
elif [ $2 = "off" ]; then
	_lstate=0
else
	echo "invalid state value ($2)"
	exit 0
fi

if [ -e /tmp/led.$_device.pid ]; then
	read PID < /tmp/led.$_device.pid
	kill -9 $PID
	rm -rf /tmp/led.$_device.pid
fi

echo $_lstate > /sys/devices/platform/leds-gpio/leds/$_device/brightness
