#!/bin/sh

_M="${0##*/}"

if [ $1 != "af" -a $1 != "card" ]; then
	echo "not support led ($1)"
	exit 0
else
	_device="$1"
fi

if [ $2 -lt 1 -a $2 -gt 99 ]; then
	echo "invalid duty value ($2)"
	exit 0
else
	_duty=$2
fi

if [ $3 -lt 100 ]; then
	echo "invalid period value ($3)"
	exit 0
else
	_period=$3
fi

# remember pid self.
echo $$ > /tmp/led.$_device.pid

# in usec
ontime=`expr $_period \* $_duty`
ontime=`expr $ontime \* 10`
offtime=`expr 100 - $_duty`
offtime=`expr $_period \* $offtime`
offtime=`expr $offtime \* 10`

while true; do
	echo 1 > /sys/devices/platform/leds-gpio/leds/$_device/brightness
	usleep $ontime
	echo 0 > /sys/devices/platform/leds-gpio/leds/$_device/brightness
	usleep $offtime
done
