#!/bin/sh

# mount new ubifs
mkdir -p /tmp/rootfs
ubiattach -p /dev/mtd4 -d 0
mount -t ubifs /dev/ubi0_0 /tmp/rootfs

# pivot root to new ubifs
cd /tmp/rootfs
mkdir oldroot
pivot_root . oldroot
cd /

# unmount old fs
mount /proc
mount --move /oldroot/dev /dev
mount -o rw,remount /dev
umount /oldroot/proc
umount /oldroot/sys
umount /oldroot/tmp
umount /oldroot/mnt/mmc

# touch file used by rcS.
touch /fw_upgrade_done
sync
sync

# tell busybox init to reload inittab
kill -HUP 1
sleep 1

# tell init reload itself.
kill -QUIT 1
sleep 3


