#!/bin/sh

FW_ROOTFS_DIR=/tmp
BINS_WITH_SO= #"/usr/bin/di-camera-app"

slp_firmware="`sed -n '2,2p' /etc/version.info | tr [:upper:] [:lower:]`.bin"

getlibs ()
{
	app=$1
	ldd $app |grep -v ":"|grep "/"|sed "s/.*>//g; s/ (.*//g; s/\.\//\//g"|awk '{print $1}'
}

# prepare new minimal rootfs in tmpfs
dirs="tmp proc sys usr/bin usr/sbin usr/lib usr/etc lib etc oldroot"
for i in $dirs; do	
	mkdir -p $FW_ROOTFS_DIR/$i
done

# copy fundamental files to new rootfs from old rootfs
dirs="/bin /sbin /etc /dev"
for i in $dirs; do
	cp -a --parents $i $FW_ROOTFS_DIR
done

tar -cf - -C /lib/ \
	--exclude=firmware \
	--exclude=init \
	--exclude=modules \
	--exclude=udev \
	--exclude=lsb \
	--exclude=systemd \
	--exclude=terminfo \
	. | tar -xf - -C /tmp/lib

# copy mtd files for firmware upgrade.
cp -a /usr/sbin/nandwrite   $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/nanddump    $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/ubiformat   $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/ubiattach   $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/ubidetach   $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/ubimkvol    $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/flash_erase $FW_ROOTFS_DIR/usr/sbin

# copy required files for firmware upgrade.
echo $slp_firmware > $FW_ROOTFS_DIR/etc/firmware  
cp -a /usr/sbin/fw_upgrade          $FW_ROOTFS_DIR/usr/sbin
cp -a /usr/sbin/pivot_rootfs_ubi.sh $FW_ROOTFS_DIR/usr/sbin
#cp -a /usr/sbin/bg_image.raw        $FW_ROOTFS_DIR/bg_image.raw
 
if [ ! -z "$BINS_WITH_SO" ]; then
	cp -aL --parents $BINS_WITH_SO $FW_ROOTFS_DIR
fi

[ ! -z "$BINS_WITH_SO" ] && for f in $BINS_WITH_SO; do
	getlibs $f >> $FW_ROOTFS_DIR/install_files_tmp
done
if [ -f $FW_ROOTFS_DIR/install_files_tmp ]; then
	sort -u $FW_ROOTFS_DIR/install_files_tmp > $FW_ROOTFS_DIR/install_files
fi

# install shared objects required for binaries.
[ -f "$FW_ROOTFS_DIR/install_files" ] && while read f; do
#	echo $f
	cp -aL --parents $f $FW_ROOTFS_DIR
done < "$FW_ROOTFS_DIR/install_files"

# prepare new rcS under new root.
cp -af /usr/sbin/rcS.pivot $FW_ROOTFS_DIR/etc/init.d/rcS

# kill all user processes
killall -9 di-camera-app-nx300 Xorg
fuser -m -k -KILL /var/tmp
fuser -m -k -KILL /opt/var/log

# pivot_root to new rootfs
pivot_root $FW_ROOTFS_DIR /tmp/oldroot

# switch shell to new root
cd /

# remount /proc
mount /proc

# tell busybox init to reload inittab
kill -HUP 1
sleep 1

# tell init reload itself.
kill -QUIT 1
sleep 3

