#!/bin/sh

echo ""
echo "============================="
echo "make partition"
echo "============================="
echo ""

# detach ubi partitions
ubidetach -p /dev/mtd4 2>/dev/null
ubidetach -p /dev/mtd6 2>/dev/null
ubidetach -p /dev/mtd7 2>/dev/null

# erase mtd4 (rootfs)
echo "erase platform.img (mtd4)..."
flash_erase /dev/mtd4 0 0
echo ""

# for snapshot
echo "erase snapshot image (mtd5)..."
flash_erase /dev/mtd5 0 0
echo ""

# make ubi node for rw_volume.	
echo "make rw_volume (mtd6)... "	
flash_erase /dev/mtd6 0 0
ubiformat /dev/mtd6 -y
ubiattach -p /dev/mtd6 -d 1 2>/dev/null
echo ""

# make ubi node for adj_volume if it's not inited yet.	
ubiattach -p /dev/mtd7 -d 2 2>/dev/null
mdev -s
if [ ! -e /dev/ubi2_0 ]; then
	echo ""
	echo "make adj_volume (mtd7)... "	
	ubidetach -p /dev/mtd7 2>/dev/null
	flash_erase /dev/mtd7 0 0
	ubiformat /dev/mtd7 -y
	ubiattach -p /dev/mtd7 -d 2 2>/dev/null
	mdev -s
	echo ""
fi	

# create ubi volume for rw_volume and adj_volume
ubimkvol /dev/ubi1 -m -N rw_volume

if [ ! -e /dev/ubi2_0 ]; then
	ubimkvol /dev/ubi2 -m -N adj_volume
fi

mdev -s
