#!/bin/bash
# Copyright (c) 2011 Samsung Electronics Co., Ltd All Rights Reserved
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
#

EXPECTED_ARGS=1

if [ $# -ne $EXPECTED_ARGS ]
then
    echo "Usage: `basename $0` {arg}, where arg could be WACPolicy UnrestrictedPolicy"
    exit 1
fi

if [ $1 = "WACPolicy" ]
then
    killall -9 wrt_engine_daemon
    wrt_reset_db.sh
    cp /usr/etc/ace/WACPolicy.xml /usr/etc/ace/demo.xml
elif [ $1 = "UnrestrictedPolicy" ]
then
    killall -9 wrt_engine_daemon
    wrt_reset_db.sh
    cp /usr/etc/ace/UnrestrictedPolicy.xml /usr/etc/ace/demo.xml
else
    echo "Invalid argument!"
    exit 1
fi

echo "Policy changed. Please restart wrt_engine_daemon"
