#!/bin/sh

check_mmc()
{
	nr_mnt_dev=`/usr/bin/stat -c %d /mnt/mmc` #/opt/storage
	nr_ums_dev=`/usr/bin/stat -c %d /mnt`     #/opt/storage/sdcard
	if [ $nr_mnt_dev = $nr_ums_dev ]
	then
		/bin/echo "UMS connection is closed. Mount mmc on target."
		umount /mnt/mmc 2> /dev/null

		for i in 0 1 2 3 4 5 6 7 8 9
		do
			/bin/echo "Try to mount mmcblk$i""p1"
			/bin/mount -t vfat /dev/mmcblk${i}p1 /mnt/mmc -o uid=0,gid=0,dmask=0000,fmask=0000,iocharset=iso8859-1,utf8,shortname=mixed
			if [ $? = 0 ]
			then
				break
			else
				/bin/echo "Try to mount mmcblk$i"
				/bin/mount -t vfat /dev/mmcblk${i} /mnt/mmc -o uid=0,gid=0,dmask=0000,fmask=0000,iocharset=iso8859-1,utf8,shortname=mixed
				if [ $? = 0 ]
				then
					break
				fi
			fi
			if [ $i = 1 ]
			then
				/bin/echo "Fail to remount mmc"
				vconftool set -t int memory/Device/Mmc 2
			fi
		done
	fi
}

mmc_status=`vconftool get memory/Device/Mmc | awk -F '=' '{printf $2}' | awk -F '(' '{printf $1}' | awk '{printf $1}'`
if [ $mmc_status = 1 ]
then
	/bin/echo "remount mmc"
	check_mmc
fi
