#!/bin/sh

_M=prefman.sh

usage()
{
	cat <<- USAGE
	
	Usage: $_M {COMMAND}  [ARGS..]
	USAGE
	
	cat <<- USAGE
	
	Utility of preference manager.
	
	Commands:
	    --start        Inititalize and load all preference data.
	    --stop         Unload and deinitialize all preference data.
			
	USAGE
	exit 0
}

if [ $# -lt 1 ]; then
	usage
	exit 1
fi

while [ $# -ge 1 ]
do
	arg="$1"
	shift
	
	case "$arg" in
	--start)
		/usr/bin/prefman init
		/usr/bin/prefman load
		exit 0
		;;
	
	--stop)
		/usr/bin/prefman save
		sync
		/usr/bin/prefman deinit
		exit 0
		;;
		
	-h|--help)
		usage
		exit 0
		;;
	
	*)
		echo "Unknown option. Please see $_M -help"
		;;
		
	esac

done
