#!/bin/sh

#  memps
#
# Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
#
# Contact: Wonil Choi <wonil22.choi@samsung.com>
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#



LD_PRELOAD=""
detail_view=0
show_all=0
target_name=""

usage()
{
	echo "--------- memps.sh ----------"
	echo "Usage:"
	echo "      - all view : memps.sh -a"
	echo "      - detail view of some process : memps.sh -d <cmdline>"
	echo "-----------------------------"
	echo "Desc.:"
	echo "      - RSS    : Resident Set Size, the portion of a process's memory that is held in RAM"
	echo "      - PSS    : Proportional Set Size, the size of RAM which is "
	echo "                 divided by the number of processes sharing it"
	echo "      - PRIVATE: the size which is owned by the process only"
	echo "      - P_DIRTY: the subset of PRIVATE, which the value is changed (may be data.)"
	echo "      - UI     : PowerVR(SGX) and Video(Frame Buffer)"
	echo "      - UI(PFN): remapped area(may be reserved by device driver)"
	exit
}


for opt in $*
do
	if [ "z"$opt = "z-d" ] 
	then
		detail_view=1
	elif [ "z"$opt = "z-a" ]
	then
		show_all=1
	elif [ "z"$opt = "z-h" -o "z"$opt = "z--help" ]
	then
		usage
	else
		target_name=$opt
	fi
done


if [ $show_all -eq 1 ]
then
	$0 | awk -f /usr/bin/smaps_awk -v show_all=1
	cat /proc/meminfo | awk -f /usr/bin/smaps_awk -v meminfo=1
	echo 
	echo "MEMORY INFO by low_mem_notify - except reclaimable pages"
	cat /sys/class/memnotify/meminfo
	exit	
fi

if [ $detail_view -ne 1 ]
then
	echo -e "RSS\tPSS\tPRIVATE\tP_DIRTY\tUI(RSS)\tUI(PSS)\tUI(PFN)\tUNKNOWN\tNAME(pid)"
	echo	 "--------------------------------------------------------------------"
fi

if [ "z"$target_name = "z" ]
then
	pid_name_list=`ps -ef | awk '{if(substr($8,0,1)!="[") {print $2 " " $8} }'`
else
	pid_name_list=`ps -ef | grep $target_name | awk '{if(substr($8,0,1)!="[") {print $2 " " $8} }'`
fi

pid=""
name=""

for pid_or_name in $pid_name_list
do
	if [ "z"$pid = "z" ]
	then
		pid=$pid_or_name
		continue
	fi

	name=$pid_or_name

	if [ "z"$pid = "z"$$ ]
	then
		pid=""
		continue
	fi
	
	if [ ! -e "/proc/$pid/smaps" ]
	then
		pid=""
		continue
	fi

	cat /proc/$pid/smaps | awk -f /usr/bin/smaps_awk -v pid=$pid -v cmd_line=$name -v detail_view=$detail_view 

	pid=""
done

