#!/bin/sh

mdev -s
ls /dev/zram0

mkdir -p /mnt/ubi1/fw/log
echo "`date` ------------------" >> /mnt/ubi1/fw/log/hib.txt

echo "Set RAMZ size"
echo $((30*1024*1024)) > /sys/block/zram0/disksize

echo "hib2.sh start... " >> /mnt/ubi1/fw/log/hib.txt

mkswap /dev/zram0
if [ $? -ne 0 ]
then
    echo "!! Error in mkswap zram0 !!"
	echo "> Error in mkswap zram0" >> /mnt/ubi1/fw/log/hib.txt
	sync
    exit
else
    echo "mkswap zram0 passed"
	echo "> mkswap zram0 passed" >> /mnt/ubi1/fw/log/hib.txt
fi

swapon /dev/zram0
if [ $? -ne 0 ]
then
    echo "!! Error in swapon zram0 !!"
	echo "> Error in swapon zram0" >> /mnt/ubi1/fw/log/hib.txt
	sync
    exit
else
    echo "swapon zram0 passed"
	echo "> swapon zram0 passed" >> /mnt/ubi1/fw/log/hib.txt
fi

flash_erase /dev/mtd9 0 0
if [ $? -lt 0 ]
then
    echo "!! Error in flash_erase /dev/mtd9 !!"
	echo "> Error in flash_erase /dev/mtd9" >> /mnt/ubi1/fw/log/hib.txt
	sync
    exit
else
    echo "flash_erase /dev/mtd9 passed"
	echo "> flash_erase /dev/mtd9 passed" >> /mnt/ubi1/fw/log/hib.txt
fi

mkswap -c /dev/mtdblock9
if [ $? -ne 0 ]
then
    echo "!! Error in mkswap mtdblock9 !!"
	echo "> Error in mkswap mtdblock9" >> /mnt/ubi1/fw/log/hib.txt
	sync
    exit
else
    echo "mkswap mtdblock9 passed"
	echo "> mkswap mtdblock9 passed" >> /mnt/ubi1/fw/log/hib.txt
fi

swapon /dev/mtdblock9
if [ $? -ne 0 ]
then
    echo "!! Error in swapon mtdblock9 !!"
	echo "> Error in swapon mtdblock9" >> /mnt/ubi1/fw/log/hib.txt
	sync
    exit
else
    echo "swapon mtdblock9 passed"
	echo "> swapon mtdblock9 passed" >> /mnt/ubi1/fw/log/hib.txt
fi

# set environment variable to let app do hibernation. 
export HIB=a

# clear dirty corresponding to adj partition.
echo 0 > /pref/dirty_adj

# remount /mnt/ubi2 with read-only
mount -o ro,remount,noatime,nodiratime,bulk_read,no_chk_data_crc /mnt/ubi2
if [ $? -ne 0 ]
then
    echo "!! Error in [/mnt/ubi2] read-only remount !!"
    exit
else
    echo "[/mnt/ubi2] read-only remount passed"
fi

# remount / with read-only
mount -o ro,remount /
if [ $? -ne 0 ]
then
    echo "!! Error in [/] read-only remount !!"
    exit
else
    echo "[/] read-only remount passed"
fi

# disable upgrade gui
fw_upgrade_display off

# mount iLinker cd image 
# mount -t iso9660 -o ro /usr/etc/iLinker.iso /mnt/cdrom

startx
sleep 1
/usr/bin/hib_exjob -r

app=`which di-camera-app`
app=`readlink $app`
$app &

