#!/bin/sh

DRV_PATH=/lib/modules
PERSIST_CONF_FILE_DIR=/data/misc/wifi
DYNAMIC_CONF_FILE_DIR=/tmp
PIDFILE_PATH=/var/run

# Driver name
DRIVER1=cfg80211
DRIVER2=ath6kl_sdio

# PID Files
DHCPD_PID_FILE=$PIDFILE_PATH/udhcpd.pid
HOSTAPD_PID_FILE=$PIDFILE_PATH/hostapd.pid
P2P_WPA_SUPPLICANT_PID_FILE=$PIDFILE_PATH/p2p_wpa_supplicant.pid
STATION_WPA_SUPPLICANT_PID_FILE=$PIDFILE_PATH/station_wpa_supplicant.pid

# Signal Name
SIG_NAME=-SIGTERM
#SIG_NAME=-SIGKILL

INTERFACE=wlan0

# Default is WWR
IEEE80211_REGDOM=00
REG_DOMAIN=0x406a

# Default is P2P disable
ATH6KL_P2P=0

# Default is emerg printk disable
EMERG_PRINTK=0

# Debug Level
DEBUG_LEVEL=
#DEBUG_LEVEL=-d

#
# Common
#
rfkill_unblock()
{
	if rfkill list | grep blocked | grep yes > /dev/null
	then
            rfkill unblock wlan
	fi

        if rfkill list | grep blocked | grep yes | grep Hard > /dev/null
        then
            rfkill unblock wlan
        fi

}

rfkill_block()
{
	if rfkill list | grep blocked | grep no > /dev/null
	then
            rfkill block wlan
	fi

        if rfkill list | grep blocked | grep no | grep Hard > /dev/null
        then
            rfkill block wlan
        fi

}

driver_load()
{
	IEEE80211_REGDOM=$1
	REG_DOMAIN=$2
	ATH6KL_P2P=$3

#	lsmod | grep dw_mmc_sdio_pltfm > /dev/null
#	if [ $? -ne 0 ]; then
#		insmod /usr/lib/dw_mmc_sdio-pltfm.ko
#		sleep 0.2
#	fi
	
	lsmod | grep $DRIVER2 > /dev/null
	if [ $? -ne 0 ]; then
		if [ $IEEE80211_REGDOM = 00 ]; then
			insmod $DRV_PATH/$DRIVER1.ko cfg80211_emerg_printk=$EMERG_PRINTK
			insmod $DRV_PATH/$DRIVER2.ko ath6kl_emerg_printk=$EMERG_PRINTK ath6kl_p2p=$ATH6KL_P2P
		else
			insmod $DRV_PATH/$DRIVER1.ko cfg80211_emerg_printk=$EMERG_PRINTK ieee80211_regdom=$IEEE80211_REGDOM
			insmod $DRV_PATH/$DRIVER2.ko ath6kl_emerg_printk=$EMERG_PRINTK ath6kl_p2p=$ATH6KL_P2P reg_domain=$REG_DOMAIN
		fi
		sleep 1

        while :
        do
            sleep 0.1
            if iwconfig ${INTERFACE} | grep "No such device" > /dev/null
            then
                continue
            else
                break
            fi
        done

        while :
        do
            sleep 0.1
            if ifconfig ${INTERFACE} | grep "Device not found" > /dev/null
            then
                continue
            else
                break
            fi
        done
	fi
}

driver_unload()
{	
	lsmod | grep $DRIVER2 > /dev/null
	if [ $? -ne 0 ]; then
		echo Wi-Fi driver not found
	else
		rfkill_unblock
		rmmod $DRIVER2
		rmmod $DRIVER1
	fi
}

clean_hostapd()
{
	if [ -f $HOSTAPD_PID_FILE ]
	then
		killall $SIG_NAME hostapd

		while :
		do
		    sleep 0.1
		    if pidof hostapd > /dev/null
		    then
		        continue
		    else
		        break
		    fi
		done
	fi

	if [ -f $HOSTAPD_PID_FILE ]
	then
		rm $HOSTAPD_PID_FILE
	fi
}

clean_p2p_supplicant()
{
	if [ -f $P2P_WPA_SUPPLICANT_PID_FILE ]
	then
		killall $SIG_NAME wpa_supplicant

		while :
		do
		    sleep 0.1
		    if pidof wpa_supplicant > /dev/null
		    then
		        continue
		    else
		        break
		    fi
		done
	fi

	if [ -f $P2P_WPA_SUPPLICANT_PID_FILE ]
	then
		rm $P2P_WPA_SUPPLICANT_PID_FILE
	fi
}

clean_station_supplicant()
{
	if [ -f $STATION_WPA_SUPPLICANT_PID_FILE ]
	then
		killall $SIG_NAME wpa_supplicant

		while :
		do
		    sleep 0.1
		    if pidof wpa_supplicant > /dev/null
		    then
		        continue
		    else
		        break
		    fi
		done
	fi

	if [ -f $STATION_WPA_SUPPLICANT_PID_FILE ]
	then
		rm $STATION_WPA_SUPPLICANT_PID_FILE
	fi
}

clean_ConnMan()
{
	if pidof connmand > /dev/null
	then
		killall $SIG_NAME connmand

		while :
		do
		    sleep 0.1
		    if pidof connmand > /dev/null
		    then
		        continue
		    else
		        break
		    fi
		done
	fi
}

clean_netconfig()
{
	if pidof net-config > /dev/null
	then
		killall $SIG_NAME net-config

		while :
		do
		    sleep 0.1
		    if pidof net-config > /dev/null
		    then
		        continue
		    else
		        break
		    fi
		done
	fi
}

shutdown()
{
	echo shutdown wlan.sh
}

check_wifi_off()
{
	lsmod | grep $DRIVER2 > /dev/null
	if [ $? -ne 0 ]; then
		echo Wi-Fi driver not found
	else
		pw=$(cat /sys/devices/platform/d4keys-polled/pw)
		if [ $pw -ne 1 ]; then
			echo wifi onshot power off
			echo 9 > sys/devices/platform/d4keys-polled/1shot
			poweroff -f
		fi
	fi
}

remove()
{
	echo remove wlan.sh
	
	check_wifi_off
	
	clean_ConnMan
	clean_netconfig
	clean_station_supplicant
	clean_p2p_supplicant
	clean_hostapd
	
#	driver_unload
	
#	if lsmod | grep dw_mmc_sdio_pltfm > /dev/null
#	then
#	    rmmod dw_mmc_sdio_pltfm
#	fi	
}

#
# ConnMan
#
start()
{
	echo start wlan.sh
	
	clean_station_supplicant
	clean_p2p_supplicant
	clean_hostapd
	
	driver_load $1 $2 1
	ifconfig ${INTERFACE} up
	ifconfig ${INTERFACE} txqueuelen 10000
	iwconfig ${INTERFACE} power off
	
	/usr/sbin/wpa_supplicant $DEBUG_LEVEL -Dnl80211 -i${INTERFACE} -c$DYNAMIC_CONF_FILE_DIR/wpa_supplicant.conf -u -B -P$STATION_WPA_SUPPLICANT_PID_FILE
}

stop()
{
	echo stop wlan.sh
	
	clean_station_supplicant

	driver_unload
}

close()
{
	echo close wlan.sh
	
	clean_ConnMan
}

#
# P2P
#
start_p2p()
{
	echo start_p2p wlan.sh

	clean_ConnMan
	clean_netconfig
	clean_station_supplicant
	clean_p2p_supplicant
	clean_hostapd
	
	driver_load $1 $2 1
	ifconfig ${INTERFACE} up
	ifconfig ${INTERFACE} txqueuelen 10000
	iwconfig ${INTERFACE} power off
	
	/usr/sbin/wpa_supplicant $DEBUG_LEVEL -Dnl80211 -i${INTERFACE} -c$DYNAMIC_CONF_FILE_DIR/wpa_supplicant.p2p.conf -u -B -P$P2P_WPA_SUPPLICANT_PID_FILE
}

stop_p2p()
{
	echo stop_p2p wlan.sh
	
	if pidof udhcpc > /dev/null                                 
	then
		release_dhcpc
		stop_dhcpc
	fi
	
	if pidof udhcpd > /dev/null                                 
	then
		stop_dhcpd 192.168.0.1
	fi
	
	clean_p2p_supplicant

	driver_unload
}

#
# SoftAP
#
start_softap()
{
	echo start_softap wlan.sh
	
	clean_ConnMan
	clean_netconfig
	clean_station_supplicant
	clean_p2p_supplicant
	clean_hostapd
	
	driver_load $1 $2 0
	ifconfig ${INTERFACE} up
	ifconfig ${INTERFACE} txqueuelen 10000
	iwconfig ${INTERFACE} power off

	/usr/sbin/hostapd $DEBUG_LEVEL $DYNAMIC_CONF_FILE_DIR/hostapd.conf -B -P$HOSTAPD_PID_FILE
}

stop_softap()
{
	echo stop_softap wlan.sh
	
	if pidof udhcpc > /dev/null
	then
		release_dhcpc
		stop_dhcpc
	fi
	
	if pidof udhcpd > /dev/null
	then
		stop_dhcpd 192.168.0.1
	fi
	
	clean_hostapd

	driver_unload
}

#
# DHCP server
#
start_dhcpd()
{
	if [ -f $DHCPD_PID_FILE ];
	then
		echo "kill udhcpd"
		killall $SIG_NAME udhcpd
	fi
	
	ifconfig ${INTERFACE} $1 up
	/usr/sbin/udhcpd $DYNAMIC_CONF_FILE_DIR/dhcpd.conf
	
	# check if localIP is already listed
	if route | grep $1 > /dev/null
	then
		route del default gw $1 dev ${INTERFACE}
	fi
	
	# add localIP as default gateway
	route add default gw $1 dev ${INTERFACE}	
}

stop_dhcpd()
{
	# if localIP is listed
	if route | grep $1 > /dev/null
	then
		route del default gw $1 dev ${INTERFACE}
	fi

	if pidof udhcpd > /dev/null
	then                                                                    
		killall $SIG_NAME udhcpd                 
	fi
	
	if ifconfig | grep ${INTERFACE} > /dev/null
	then
		ifconfig ${INTERFACE} 0
	fi
}

#
# DHCP client
#
start_dhcpc()
{
	if pidof udhcpc > /dev/null
	then
		killall -SIGTERM udhcpc
	fi
	
	/sbin/udhcpc -i ${INTERFACE} -s /usr/bin/dhcpc.sh &
}

release_dhcpc()
{
	if pidof udhcpc > /dev/null
	then
		killall -SIGUSR2 udhcpc
	fi
}

stop_dhcpc()
{
	if pidof udhcpc > /dev/null
	then
		killall -SIGTERM udhcpc
	fi
}

#
# AutoIP
#
start_autoip()
{
	stop_dhcpc
	/sbin/udhcpc -i ${INTERFACE} -s /usr/share/udhcpc/udhcpc.script &
}

case $1 in
	"start")
		start $2 $3
		;;
	"stop")
		stop
		;;
	"close")
		close
		;;
	"shutdown")
		shutdown
		;;
	"remove")
		remove
		;;
	"start_dhcpc")
		start_dhcpc
		;;
	"release_dhcpc")
		release_dhcpc
		;;
	"stop_dhcpc")
		stop_dhcpc
		;;
	"start_autoip")
		start_autoip
		;;
	"start_dhcpd")
		start_dhcpd $2
		;;
	"stop_dhcpd")
		stop_dhcpd $2
		;;
	"start_softap")
		start_softap $2 $3
		;;
	"stop_softap")
		stop_softap
		;;
	"start_p2p")
		start_p2p $2 $3
		;;
	"stop_p2p")
		stop_p2p
		;;
	*)
		echo wlan.sh [start] [stop] [close] [shutdown] [remove] [start_dhcpc] [release_dhcpc] [stop_dhcpc] [start_autoip] [start_dhcpd] [stop_dhcpd] [start_softap] [stop_softap] [start_p2p] [stop_p2p] [mfton] [mftoff] [rftest]
		exit 1
		;;
esac
