#!/bin/sh

if [ "$1" = "--set" ]
then
	vconftool set -t int db/setting/keeping_debug "1"
	vconftool set -t int memory/setting/usb_sel_mode "3"
	echo "Keeping_debug = SET"
	echo "Debug mode is loaded"
	
elif [ "$1" = "--unset" ]
then
	vconftool set -t int db/setting/keeping_debug "0"
	vconftool set -t int memory/setting/usb_sel_mode "0"
	echo "Keeping_debug = UNSET"
	echo "Samsung kies mode is loaded"

elif [ "$1" = "--keep" ]
then
	vconftool set -t int db/setting/keeping_debug "1"
	echo "KEEPING_DEBUG = SET"
	 
elif [ "$1" = "--default" ]
then
	vconftool set -t int db/setting/keeping_debug "0"
	echo "KEEPING_DEBUG = UNSET"


elif [ "$1" = "--load" ]
then
	vconftool set -t int memory/setting/usb_sel_mode "3"
	echo "Debug mode is loaded"

elif [ "$1" = "--debug" ]
then
	vconftool set -t int db/setting/keeping_debug "1"
	echo "Keeping_debug = SET"
	vconftool set -t int memory/setting/usb_sel_mode "3"
	echo "Debug mode is loaded"
	vconftool -g 6514 set -t int db/MainLCD/Backlight/Normal "600"
	echo "The backlight time of the display is set to 10 minutes"
	vconftool -g 6514 set -t bool db/setting/brightness_automatic "1"
	echo "Brightness is set automatic"



elif [ "$1" = "--help" ]
then
	echo "set_usb_debug.sh: usage:"
	echo "    --help      this message "
	echo "    --set       load Debug mode and keep Debug mode when current USB mode is Debug mode and USB cable is removed"
	echo "    --unset     load Kies mode and change USB mode to Kies mode (default mode) when USB cable is removed"
	echo "    --keep      keep debug mode when current USB mode is debug mode and USB cable is removed"
	echo "    --default   change USB mode to KIES mode (default mode) when USB cable is removed"
	echo "    --load      load debug mode without pushing a button on SETTINGS"

else
	echo "Wrong parameters. Please use option --help to check options "

fi
