#!/bin/sh
#
# Restore rw partition.
#

# link /pref to rw partition.
mkdir -p /mnt/ubi1/pref
if [ "`readlink /pref`" != "/mnt/ubi1/pref" ]; then
	ln -s /mnt/ubi1/pref /pref
fi

# path of rw_volume
datapath=/mnt/ubi1/data
orgpath=/org

if [ ! -e $orgpath ]; then
	mkdir -p $orgpath
fi

if [ ! -e $datapath ]; then
	mkdir -p $datapath
fi

# move some directory to rw partition.
rwvar="/var/lib \
       /data/misc/wifi \
       /opt/dbspace \
       /opt/apps/com.samsung.browser/data \
       /opt/var/cache/fontconfig"
	   
for i in $rwvar; do	
	mkdir -p $datapath/$i
	cd $orgpath/$i
	cp -a . $datapath/$i
done

echo 0 > /pref/dirty_adj
