#!/bin/sh

if ! [ -e /dev/gpio_pk ]; then
	mknod /dev/gpio_pk c 214 0
fi

if [ -e /dev/ubi1 ]; then
	ubidetach -d 1
fi

if [ -e /dev/ubi2 ]; then
	ubidetach -d 2
fi

flash_erase /dev/mtd6 0 0
ubiformat /dev/mtd6 -y
ubiattach /dev/ubi_ctrl -m 6

flash_erase /dev/mtd7 0 0
ubiformat /dev/mtd7 -y
ubiattach /dev/ubi_ctrl -m 7

mdev -s
sleep 1

ubimkvol /dev/ubi1 -N rw_boot -m
ubimkvol /dev/ubi2 -N rw_volume -m

mdev -s
sleep 1

if ! [ -e /mnt/ubi1 ]; then
	mkdir -p /mnt/ubi1
fi
if ! [ -e /mnt/ubi2 ]; then
	mkdir -p /mnt/ubi2
fi

mount -t ubifs /dev/ubi1_0 /mnt/ubi1
mount -t ubifs /dev/ubi2_0 /mnt/ubi2

cd /opt/
mv dbspace/ _dbspace
mkdir dbspace
cd _dbspace/

for a in .*
do
	cp $a /mnt/ubi1/
done

cp -R DCMDB /mnt/ubi1/

sync
sync
sync