#!/bin/sh

# This script is for developers.
# It will reboot after touch snapshot request.

if [ ! -e /mnt/ubi1 ]; then
	echo "Mount rw partition first!"
	exit
fi

mkdir -p /mnt/ubi1/fw
touch /mnt/ubi1/fw/snapshot
echo 0 > /mnt/ubi1/fw/snapshot
sync

echo "Erasing snapshot image (/dev/mtd9)..."
flash_erase /dev/mtd9 0 0

# Default: keep current page cache list
# Use "hib.sh clean" command if want to re-create page cache list.
if [ $1 = "clean" ]; then
	echo "Erasing page cache list (/dev/mtd5)..."
	flash_erase /dev/mtd5 0 0
	
	FW_UPGRADE_CHECK=`prefman info 1 | grep APPPREF_FW_UPGRADE_CHECK | awk '{print $1}'`
	prefman set 1 $FW_UPGRADE_CHECK l 1	
	prefman save 1
fi

reboot -f

